/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.spruceui.util.Nameable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1100;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class LBGLayerType
implements Nameable {
    private static final List<LBGLayerType> LAYER_TYPES = new ArrayList<LBGLayerType>();
    public final class_2960 id;
    public final class_2248 block;
    public final class_2960 modelId;
    private final String name;

    public LBGLayerType(class_2960 id, class_2248 block, class_2960 modelId) {
        this.id = id;
        this.block = block;
        this.modelId = modelId;
        String[] path = this.id.method_12832().split("/");
        this.name = path[path.length - 1];
    }

    public class_1100 getLayerModel(Function<class_2960, class_1100> modelGetter) {
        return modelGetter.apply(this.modelId);
    }

    public String getName() {
        return this.name;
    }

    public static void reset() {
        LAYER_TYPES.clear();
    }

    public static void forEach(Consumer<LBGLayerType> consumer) {
        LAYER_TYPES.forEach(consumer);
    }

    @Nullable
    public static LBGLayerType fromName(String name) {
        for (LBGLayerType type : LAYER_TYPES) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    public static void load(class_2960 resourceId, class_3300 resourceManager) {
        class_2960 id = new class_2960(resourceId.method_12836(), resourceId.method_12832().replace(".json", ""));
        try {
            InputStream stream = resourceManager.method_14486(resourceId).method_14482();
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
            class_2960 affectId = new class_2960(json.get("block").getAsString());
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(affectId);
            if (block == class_2246.field_10124) {
                return;
            }
            class_2960 modelId = new class_2960(json.get("model").getAsString());
            stream.close();
            LAYER_TYPES.add(new LBGLayerType(id, block, modelId));
        }
        catch (IOException | IllegalStateException e) {
            LambdaBetterGrass.get().warn("Failed to load layer type \"" + id + "\".");
        }
    }

    public String toString() {
        return "LBGLayerType{id=" + this.id + ", block=" + this.block + ", modelId=" + this.modelId + "}";
    }
}

